const { DataTypes } = require("sequelize");

const sequelize = require("../config/db");
const Menu = require("./Menu");
const MenuCategory = require("./MenuCategory");


const M_MC = sequelize.define("M_MC", {
    id: {
        type: DataTypes.INTEGER,
        autoIncrement: true,
        primaryKey: true,
        allowNull: false,
    },
    menuId: {
        type: DataTypes.INTEGER,
        references: {
            model: Menu,
            key: "id"
        }
    },
    categoryId: {
        type: DataTypes.INTEGER,
        references: {
            model: MenuCategory,
            key: "id"
        }
    },
    description: {
        type: DataTypes.STRING("200"),
        allowNull: true,
    },
    sort: {
        type: DataTypes.INTEGER,
        allowNull: false,
    },
    active: {
        type: DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: true,
    },
});

Menu.hasMany(M_MC, { foreignKey: "menuId", as: "categories" });
MenuCategory.hasMany(M_MC, { foreignKey: "categoryId", as: "menus" });
M_MC.belongsTo(Menu, { foreignKey: "menuId", as: "menu" });
M_MC.belongsTo(MenuCategory, { foreignKey: "categoryId", as: "category" });


module.exports = M_MC;
