const { DataTypes } = require("sequelize");

const sequelize = require("../config/db");
const User = require("./User");
const Workgroup = require("./Workgroup");
const City = require("./City");

const Menu = sequelize.define("Menu", {
    id: {
        type: DataTypes.INTEGER,
        autoIncrement: true,
        primaryKey: true,
        allowNull: false,
    },
    name: {
        type: DataTypes.STRING("40"),
        allowNull: false,
    },
    address: {
        type: DataTypes.STRING,
        allowNull: false,
    },
    description: {
        type: DataTypes.STRING("400"),
        allowNull: true,
    },
    logo: {
        type: DataTypes.STRING,
        allowNull: true,
    },
    image: {
        type: DataTypes.STRING,
        allowNull: true,
    },
    location: {
        type: DataTypes.STRING,
        allowNull: true,
    },
    instagram: {
        type: DataTypes.STRING("40"),
        allowNull: true,
    },
    phoneNumber: {
        type: DataTypes.STRING("11"),
        allowNull: true,
    },
    colorTheme: {
        type: DataTypes.STRING("7"),
        allowNull: true,
        defaultValue: "#AA3FFF"
    },
    darkMode: {
        type: DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: false
    },
    theme: {
        type: DataTypes.INTEGER("999"),
        allowNull: true,
        defaultValue: 2
    },
    startDate: {
        type: DataTypes.DATE,
        allowNull: true,
    },
    endDate: {
        type: DataTypes.DATE,
        allowNull: true,
    },
    active: {
        type: DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: false,
    },
    status: {
        type: DataTypes.ENUM('0', '1', '2', '3'), // ناموفق 0 ، در انتظار تایید 1 ، تایید شده 2 ، تایید نشده 3
        allowNull: false,
        defaultValue: '0',
    },
    lat: {
        type: DataTypes.STRING("40"),
        allowNull: true,
    },
    lng: {
        type: DataTypes.STRING("40"),
        allowNull: true,
    },
    valueAddedPrice: {
        type: DataTypes.INTEGER("99"),
        allowNull: false,
        defaultValue: 0,
    },
    workgroupId: {
        type: DataTypes.INTEGER,
        references: {
            model: Workgroup,
            key: "id"
        }
    },
    cityId: {
        type: DataTypes.INTEGER,
        references: {
            model: City,
            key: "id"
        },
    },
    userId: {
        type: DataTypes.INTEGER,
        references: {
            model: User,
            key: "id"
        }
    }
});

Menu.belongsTo(Workgroup, { as: 'workgroup', foreignKey: "workgroupId" })
Menu.belongsTo(City, { as: 'city', foreignKey: "cityId" })
Menu.belongsTo(User, { as: 'user', foreignKey: "userId" })


module.exports = Menu;