const { DataTypes } = require("sequelize");

const sequelize = require("../config/db");
const Workgroup = require("./Workgroup");

const MenuCategory = sequelize.define("MenuCategory", {
    id: {
        type: DataTypes.INTEGER,
        autoIncrement: true,
        primaryKey: true,
        allowNull: false,
    },
    title: {
        type: DataTypes.STRING("30"),
        allowNull: false,
    },
    svg: {
        type: DataTypes.TEXT("long"),
        allowNull: false,
    },
    workgroupId: {
        type: DataTypes.INTEGER,
        allowNull: false,
        references: {
            model: Workgroup,
            key: "id"
        }
    }
});


MenuCategory.belongsTo(Workgroup, { as: 'workgroup', foreignKey: "workgroupId" })

module.exports = MenuCategory;