const { DataTypes } = require("sequelize");

const sequelize = require("../config/db");
const Menu = require("./Menu");
const MenuPlan = require("./MenuPlan");

const MenuOrders = sequelize.define("MenuOrders", {
    id: {
        type: DataTypes.INTEGER,
        autoIncrement: true,
        primaryKey: true,
        allowNull: false,
    },
    orderCode: {
        type: DataTypes.INTEGER("999999999"),
        allowNull: true,
    },
    price: {
        type: DataTypes.INTEGER("999999999"),
        allowNull: false,
    },
    discount: {
        type: DataTypes.INTEGER("100"),
        allowNull: false,
        defaultValue: 0
    },
    discountCode: {
        type: DataTypes.STRING("20"),
    },
    isPay: {
        type: DataTypes.BOOLEAN,
        allowNull: false,
    },
    authority: {
        type: DataTypes.STRING,
    },
    refId: {
        type: DataTypes.INTEGER,
        allowNull: false,
        defaultValue: 0,
    },
    menuId: {
        type: DataTypes.INTEGER,
        allowNull: false,
        references: {
            model: Menu,
            key: "id"
        },
    },
    planId: {
        type: DataTypes.INTEGER,
        allowNull: false,
        references: {
            model: MenuPlan,
            key: "id"
        },
    }
});

Menu.hasMany(MenuOrders, { foreignKey: "menuId", as: "orders" });
MenuPlan.hasMany(MenuOrders, { foreignKey: "planId" });
MenuOrders.belongsTo(Menu, { foreignKey: "menuId", as: "menu" });
MenuOrders.belongsTo(MenuPlan, { foreignKey: "planId", as: "plan" });

module.exports = MenuOrders;