const Yup = require("yup");

const phoneRegex = /((09))((14)|(13)|(12)|(19)|(18)|(17)|(15)|(16)|(11)|(10)|(90)|(91)|(92)|(93)|(94)|(95)|(96)|(32)|(30)|(33)|(35)|(36)|(37)|(38)|(39)|(00)|(01)|(02)|(03)|(04)|(05)|(41)|(20)|(21)|(22)|(23)|(31)|(34)|(9910)|(9911)|(9913)|(9914)|(9999)|(999)|(990)|(9810)|(9811)|(9812)|(9813)|(9814)|(9815)|(9816)|(9817)|(998))\W?\d{3}\W?\d{4}/g


const message = {
    required: "لطفا این قسمت را خالی نگذارید"
};


exports.schemaLoginPhoneNumber = Yup.object().shape({
    phone: Yup.string()
        .required(message.required)
        .matches(phoneRegex, 'شماره موبایل نادرست است.'),
});

exports.schemaPassword = Yup.object().shape({
    phone: Yup.string()
        .required(message.required)
        .matches(phoneRegex, 'شماره یا کلمه عبور اشتباه است'),
    password: Yup.string()
        .required(message.required)
        .min(8, "شماره یا کلمه عبور اشتباه است"),
});


exports.schemaUser = Yup.object().shape({
    fullname: Yup.string()
        .required("نام و نام خانوادگی الزامی می باشد")
        .min(3, "نام و نام خانوادگی نباید کمتر از 3 کاراکتر باشد")
        .max(255, "نام و نام خانوادگی نباید بیشتر از 255 کاراکتر باشد"),
    password: Yup.string()
        .min(8, "کلمه عبور نباید کمتر از 8 کاراکتر باشد")
        .max(255, "کلمه عبور نباید بیشتر از 255 کاراکتر باشد")
        .required("کلمه عبور الزامی می باشد"),
    confirmPassword: Yup.string()
        .required("تکرار کلمه عبور الزامی می باشد")
        .oneOf([Yup.ref("password"), null], "کلمه های عبور یکسان نیستند")
});

exports.schemaUserEdit = Yup.object().shape({
    fullname: Yup.string()
        .required("نام و نام خانوادگی الزامی می باشد")
        .min(3, "نام و نام خانوادگی نباید کمتر از 3 کاراکتر باشد")
        .max(255, "نام و نام خانوادگی نباید بیشتر از 255 کاراکتر باشد")
});