const { Router } = require("express");
const menuController = require("../../controllers/user/menuController");

const { authenticated, authenticatedMenuUser } = require("../../middlewares/auth");

const router = new Router();


//  @desc GET Menus
//  @route  GET /menu/:address
router.get("/menu/:address", authenticated, menuController.getMenu);


//  @desc GET Menus
//  @route  GET /user/menus
router.get("/menus", authenticated, menuController.getMenus);

//  @desc GET Menus
//  @route  GET /user/menu
router.get("/menu-orders", authenticated, menuController.getMenuOrders);

//  @desc GET Menus
//  @route  GET /user/menu
router.get("/draft-menu", authenticated, menuController.getDraftMenu);

//  @desc GET Menus
//  @route  GET /user/menu
router.get("/generate-QRMenu/:address", authenticated, menuController.getQRMenu);

//  @desc  Create Menu
//  @route  POST /user/create-menu
router.post("/buy-menu", authenticated, menuController.buyMenuPlan);

//  @desc  Edit Menu
//  @route  PUT /user/edit-menu
router.put("/edit-menu", authenticated, authenticatedMenuUser, menuController.editMenu);

//  @desc  Edit Menu
//  @route  PUT /user/edit-menu
router.put("/edit-menu-theme", authenticated, authenticatedMenuUser, menuController.editMenuTheme);

//  @desc   Check Address Menu
//  @route  PUT /user/check-address-menu
router.post("/check-address-menu", authenticated, menuController.checkAddressMenu);

//  @desc  Edit Menu
//  @route  PUT /user/edit-menu-info
router.put("/edit-menu-info", authenticated, authenticatedMenuUser, menuController.editMenuInfo);

//  @desc  Edit Menu
//  @route  PUT /user/edit-menu-info
router.put("/edit-menu-contact", authenticated, authenticatedMenuUser, menuController.editMenuContact);

//  @desc  Edit Menu
//  @route  PUT /user/edit-menu-loaction
router.put("/edit-menu-loaction", authenticated, authenticatedMenuUser, menuController.editMenuLocation);





//  @desc  Add Menu Category
//  @route  POST /user/add-menu-category
router.post("/add-menu-category", authenticated, authenticatedMenuUser, menuController.addMenuCategory);

//  @desc  SORT LINK
//  @route  PUT /user/edit-menu-category
router.put("/edit-menu-category", authenticated, authenticatedMenuUser, menuController.editMenuCategory);


//  @desc  SORT LINK
//  @route  PUT /user/sort-link
router.put("/sort-menu-category", authenticated, authenticatedMenuUser, menuController.sortMenuCategory);

//  @desc  SORT LINK
//  @route  PUT /user/sort-link
router.put("/active-menu-category/:id", authenticated, authenticatedMenuUser, menuController.activeMenuCategory);

//  @desc  Delete Menu Category
//  @route  DELETE /user/delete-menu-category
router.delete("/delete-menu-category/:categoryId", authenticated, menuController.deleteMenuCategory);



//  @desc  Add Menu Item
//  @route  POST /user/add-menu-item
router.post("/add-menu-item", authenticated, authenticatedMenuUser, menuController.addMenuItem);

//  @desc  Edit Menu
//  @route  PUT /user/edit-menu-item/:id
router.put("/edit-menu-item/:id", authenticated, authenticatedMenuUser, menuController.editMenuItem);

//  @desc  SORT LINK
//  @route  PUT /user/sort-link
router.put("/sort-menu-items", authenticated, authenticatedMenuUser, menuController.sortMenuItem);

//  @desc  SORT LINK
//  @route  PUT /user/sort-link
router.put("/active-menu-item/:id", authenticated, authenticatedMenuUser, menuController.activeMenuItem);

//  @desc  Delete Menu Item
//  @route  DELETE /user/delete-menu-item
router.delete("/delete-menu-item/:id", authenticated, authenticatedMenuUser, menuController.deleteMenuItem);

//  @desc  Add Menu Item
//  @route  POST /user/add-menu-item
router.post("/copy-menu-item", authenticated, authenticatedMenuUser, menuController.copyMenuItem);

//  @desc  SORT LINK
//  @route  PUT /user/sort-link
router.put("/change-menu-item-category/:id", authenticated, authenticatedMenuUser, menuController.changeMenuItemCategory);




//  @desc  Add Menu Item
//  @route  POST /user/add-menu-item
router.post("/add-menu-notification", authenticated, authenticatedMenuUser, menuController.addMenuNotification);

//  @desc  Edit Menu
//  @route  PUT /user/edit-menu-item/:id
router.put("/edit-menu-notification/:id", authenticated, authenticatedMenuUser, menuController.editMenuNotification);

//  @desc  SORT LINK
//  @route  PUT /user/sort-link
router.put("/active-menu-notification/:id", authenticated, authenticatedMenuUser, menuController.activeMenuNotification);

//  @desc  SORT LINK
//  @route  PUT /user/sort-link
router.put("/pin-menu-notification/:id", authenticated, authenticatedMenuUser, menuController.pinMenuNotification);

//  @desc  Delete Menu Item
//  @route  DELETE /user/delete-menu-item
router.delete("/delete-menu-notification/:id", authenticated, authenticatedMenuUser, menuController.deleteMenuNotification);


module.exports = router;