const { DataTypes } = require("sequelize");

const sequelize = require("../config/db");
const Link = require("./Link");


const Block = sequelize.define("Block", {
    id: {
        type: DataTypes.INTEGER,
        autoIncrement: true,
        primaryKey: true,
        allowNull: false,
    },
    title: {
        type: DataTypes.STRING("60"),
        allowNull: true,
    },
    colorType: {
        type: DataTypes.ENUM("1", "2", "3"),
        allowNull: false,
        defaultValue: "1",
    },
    radiusType: {
        type: DataTypes.ENUM("1", "2"),
        allowNull: false,
        defaultValue: "1",

    },
    widthType: {
        type: DataTypes.ENUM("1", "2", "3"),
        allowNull: false,
        defaultValue: "1",
    },
    bg: {
        type: DataTypes.STRING("7"),
        allowNull: true,
        defaultValue: "",
    },
    color: {
        type: DataTypes.STRING("7"),
        allowNull: true,
        defaultValue: "",
    },
    coloBorder: {
        type: DataTypes.STRING("7"),
        allowNull: true,
        defaultValue: "",
    },
    radius: {
        type: DataTypes.ENUM("1", "2", "3", "4"),
        allowNull: false,
        defaultValue: "1",
    },
    type: {
        type: DataTypes.STRING("60"),
        allowNull: false,
    },
    sort: {
        type: DataTypes.INTEGER,
        allowNull: false,
    },
    isActive: {
        type: DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: true,
    },
    linkId: {
        type: DataTypes.INTEGER,
        allowNull: false,
        references: {
            model: Link,
            key: "id"
        }
    },

});


Link.hasMany(Block, { foreignKey: "linkId", as: "blocks" });
Block.belongsTo(Link, { foreignKey: "linkId", as: "link" });

module.exports = Block;
