const { DataTypes } = require("sequelize");
const sequelize = require("../config/db");
const Contact = require("./Contact");
const Block = require("./Block");


const L_C = sequelize.define("L_C", {
    id: {
        type: DataTypes.INTEGER,
        autoIncrement: true,
        primaryKey: true,
        allowNull: false,
    },
    title: {
        type: DataTypes.STRING("30"),
        allowNull: true,
    },
    address: {
        type: DataTypes.STRING,
        allowNull: false,
    },
    sort:{
        type: DataTypes.INTEGER,
        allowNull: false,
    },
    contactId: {
        type: DataTypes.INTEGER,
        allowNull: false,
        references: {
            model: Contact,
            key: "id"
        }
    },
    blockId: {
        type: DataTypes.INTEGER,
        allowNull: false,
        references: {
            model: Block,
            key: "id"
        }
    },
});


Contact.hasMany(L_C, { foreignKey: "contactId", as: "blocks" });
Block.hasMany(L_C, { foreignKey: "blockId", as: "contacts" });

L_C.belongsTo(Contact, { foreignKey: "contactId", as: "data" });
L_C.belongsTo(Block, { foreignKey: "blockId", as: "block" });

module.exports = L_C;
