const { Router } = require("express");

const menuController = require("../../controllers/admin/menuController");

const { authenticatedGeneralManager } = require("../../middlewares/auth");

const router = new Router();


//  @desc  GET Menu Plans
//  @route  GET /menuPlans
router.get("/menu-plans", authenticatedGeneralManager, menuController.getMenuPlans);

//  @desc   Admin Handle Get Menu Plan
//  @route  GET /admin/menuPlan/:id
router.get("/menu-plan/:id", authenticatedGeneralManager, menuController.getMenuPlan);

//  @desc  CREATE Menu Plan
//  @route  POST /create-menuPlan
router.post("/create-menu-plan", authenticatedGeneralManager, menuController.createMenuPlan);

//  @desc  PUT Menu Plan
//  @route  PUT /edit-menuPlan
router.put("/edit-menu-plan/:id", authenticatedGeneralManager, menuController.editMenuPlan);

//  @desc  DELETE Menu Plan
//  @route  DELETE /delete-menuPlan
router.delete("/delete-menu-plan/:id", authenticatedGeneralManager, menuController.deleteMenuPlan);



//  @desc  GET Workgroups
//  @route  GET /workgroups
router.get("/workgroups", authenticatedGeneralManager, menuController.getWorkgroups);

//  @desc   Admin Handle Get Workgroup
//  @route  GET /admin/workgroup/:id
router.get("/workgroup/:id", authenticatedGeneralManager, menuController.getWorkgroup);

//  @desc  CREATE Workgroup
//  @route  POST /create-workgroup
router.post("/create-workgroup", authenticatedGeneralManager, menuController.createWorkgroup);

//  @desc  PUT Workgroup
//  @route  PUT /edit-workgroup
router.put("/edit-workgroup/:id", authenticatedGeneralManager, menuController.editWorkgroup);

//  @desc  DELETE Workgroup
//  @route  DELETE /delete-workgroup
router.delete("/delete-workgroup/:id", authenticatedGeneralManager, menuController.deleteWorkgroup);



//  @desc  GET Menu Categories
//  @route  GET /menu-categories
router.get("/menu-categories", authenticatedGeneralManager, menuController.getMenuCategories);

//  @desc   Admin Handle Get Menu Category
//  @route  GET /admin/menu-category/:id
router.get("/menu-category/:id", authenticatedGeneralManager, menuController.getMenuCategory);

//  @desc  CREATE Menu Category
//  @route  POST /create-menu-category
router.post("/create-menu-category", authenticatedGeneralManager, menuController.createMenuCategory);

//  @desc  PUT Menu Category
//  @route  PUT /edit-menu-category
router.put("/edit-menu-category/:id", authenticatedGeneralManager, menuController.editMenuCategory);

//  @desc  DELETE Menu Category
//  @route  DELETE /delete-menu-category
router.delete("/delete-menu-category/:id", authenticatedGeneralManager, menuController.deleteMenuCategory);


//  @desc  GET Menus
//  @route  GET /menus
router.get("/menus", authenticatedGeneralManager, menuController.getMenus);

//  @desc  GET Menu Orders
//  @route  GET /menu-orders
router.get("/menu-orders", authenticatedGeneralManager, menuController.getMenuOrders);

//  @desc  GET Confirm Menus
//  @route  GET /confirm-menus
router.get("/confirm-menus", authenticatedGeneralManager, menuController.getConfirmMenus);

//  @desc  Confirm Menu
//  @route  POST /confirm-menu/:id
router.post("/confirm-menu/:id", authenticatedGeneralManager, menuController.confirmMenu);


module.exports = router;
