const { DataTypes } = require("sequelize");

const sequelize = require("../config/db");
const Province = require("./Province");

const City = sequelize.define("City", {
    id: {
        type: DataTypes.INTEGER,
        autoIncrement: true,
        primaryKey: true,
        allowNull: false,
    },
    provinceId: {
        type: DataTypes.INTEGER("60"),
        references: {
            model: Province,
            key: "id"
        }
    },
    name: {
        type: DataTypes.STRING("80"),
        allowNull: true,
    }
}, {
    timestamps: false,
});

City.belongsTo(Province, { as: 'province', foreignKey: "provinceId" })
Province.hasMany(City, { foreignKey: "provinceId", as: "cities" });

module.exports = City;