const { DataTypes } = require("sequelize");

const sequelize = require("../config/db");

const Contact = sequelize.define("Contact", {
    id: {
        type: DataTypes.INTEGER,
        autoIncrement: true,
        primaryKey: true,
        allowNull: false,
    },
    title: {
        type: DataTypes.STRING,
        allowNull: false,
    },
    svg: {
        type: DataTypes.STRING('10000'),
        allowNull: false,
    },
    color: {
        type: DataTypes.STRING('7'),
        allowNull: false,
    },
    link: {
        type: DataTypes.STRING,
        allowNull: false,
    }
});


module.exports = Contact;