const { DataTypes } = require("sequelize");

const sequelize = require("../config/db");
const Socialmedia = require("./Socialmedia");
const Link = require("./Link");
const Block = require("./Block");


const L_S = sequelize.define("L_S", {
    id: {
        type: DataTypes.INTEGER,
        autoIncrement: true,
        primaryKey: true,
        allowNull: false,
    },
    title: {
        type: DataTypes.STRING("40"),
        allowNull: true,
    },
    address: {
        type: DataTypes.STRING,
        allowNull: false,
    },
    sort: {
        type: DataTypes.INTEGER,
        allowNull: false,
    },
    socialmediaId: {
        type: DataTypes.INTEGER,
        allowNull: false,
        references: {
            model: Socialmedia,
            key: "id"
        }
    },
    blockId: {
        type: DataTypes.INTEGER,
        allowNull: false,
        references: {
            model: Block,
            key: "id"
        }
    }

});



Socialmedia.hasMany(L_S, { foreignKey: "socialmediaId", as: "blocks" });
Block.hasMany(L_S, { foreignKey: "blockId", as: "socialmedia" });

L_S.belongsTo(Socialmedia, { foreignKey: "socialmediaId", as: "data" });
L_S.belongsTo(Block, { foreignKey: "blockId", as: "block" });

module.exports = L_S;
