const { DataTypes } = require("sequelize");

const sequelize = require("../config/db");
const User = require("./User");

const Link = sequelize.define("Link", {
    id: {
        type: DataTypes.INTEGER,
        autoIncrement: true,
        primaryKey: true,
        allowNull: false,
    },
    title: {
        type: DataTypes.STRING("60"),
        allowNull: false,
    },
    description: {
        type: DataTypes.STRING("80"),
        allowNull: true,
    },
    profile: {
        type: DataTypes.STRING,
        allowNull: false,
    },
    thumbnail: {
        type: DataTypes.STRING,
        allowNull: true,
    },
    address: {
        type: DataTypes.STRING,
        allowNull: false,
        unique:true
    },
    bg:{
        type: DataTypes.STRING("7"),
        allowNull: true,
        defaultValue : "#ffffff"
    },
    bgBlock:{
        type: DataTypes.STRING("7"),
        allowNull: true,
    },
    colorBlock:{
        type: DataTypes.STRING("7"),
        allowNull: true,
    },
    colorBorderBlock:{
        type: DataTypes.STRING("7"),
        allowNull: true,
    },
    coloText:{
        type: DataTypes.STRING("7"),
        allowNull: true,
    },
    themeRadius:{
        type: DataTypes.ENUM("1", "2", "3", "4"),
        allowNull: true,
        defaultValue : "2"
    },
    profileRadius:{
        type: DataTypes.ENUM("1", "2", "3", "4"),
        allowNull: true,
        defaultValue : "2"
    },
    thumbnailRadius:{
        type: DataTypes.ENUM("1", "2"),
        allowNull: true,
        defaultValue : "2"
    },
    theme: {
        type: DataTypes.INTEGER,
        allowNull: true,
    },
    userId: {
        type: DataTypes.INTEGER,
        allowNull: false,
        references: {
            model: User,
            key: "id"
        }
    }
});

User.hasMany(Link, {as: "links", foreignKey: "userId" });

Link.belongsTo(User, {
    foreignKey: 'userId',
    onDelete: 'CASCADE',
    onUpdate: 'CASCADE',
    constraints: true,
    foreignKeyConstraint: {
      name: 'userId'
    }
  });
module.exports = Link;