const { DataTypes } = require("sequelize");

const sequelize = require("../config/db");
const Menu = require("./Menu");
const Workgroup = require("./Workgroup");


const M_W = sequelize.define("M_W", {
    id: {
        type: DataTypes.INTEGER,
        autoIncrement: true,
        primaryKey: true,
        allowNull: false,
    },
    menuId: {
        type: DataTypes.INTEGER,
        allowNull: false,
        references: {
            model: Menu,
            key: "id"
        }
    },
    workgroupId: {
        type: DataTypes.INTEGER,
        allowNull: false,
        references: {
            model: Workgroup,
            key: "id"
        }
    }
});


Menu.belongsToMany(Workgroup, { through: M_W, foreignKey: "menuId", as: "workgropus" });
Workgroup.belongsToMany(Menu, { through: M_W, foreignKey: "workgroupId", as: "menus" });



module.exports = M_W;
