const { DataTypes } = require("sequelize");

const sequelize = require("../config/db");
const Menu = require("./Menu");

const MenuNotification = sequelize.define("MenuNotification", {
    id: {
        type: DataTypes.INTEGER,
        autoIncrement: true,
        primaryKey: true,
        allowNull: false,
    },
    title: {
        type: DataTypes.STRING("60"),
        allowNull: false,
    },
    text: {
        type: DataTypes.STRING("400"),
        allowNull: false,
    },
    type: {
        type: DataTypes.ENUM("info", "warning", "error", "success"),
        allowNull: false,
        defaultValue: "info",
    },
    active: {
        type: DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: true,
    },
    pin: {
        type: DataTypes.BOOLEAN,
        allowNull: false,
        defaultValue: false,
    },
    menuId: {
        type: DataTypes.INTEGER,
        references: {
            model: Menu,
            key: "id"
        }
    },
});

Menu.hasMany(MenuNotification, { foreignKey: "menuId", as: "notification" });
MenuNotification.belongsTo(Menu, { foreignKey: "menuId", as: "menu" });


module.exports = MenuNotification;