const { Router } = require("express");

const userController = require("../../controllers/admin/userController");

const { authenticatedGeneralManager } = require("../../middlewares/auth");

const router = new Router();


//  @desc   Admin Handle Get Users
//  @route  GET /admin/users
router.get("/users", authenticatedGeneralManager, userController.getUsers);

//  @desc   Admin Handle Get User
//  @route  GET /admin/user/:id
router.get("/user/:id", authenticatedGeneralManager, userController.getUser);

//  @desc   Admin Handle User Creation
//  @route  POST /admin/add-user
router.post("/add-user", authenticatedGeneralManager, userController.addUser);

//  @desc   Admin Handle User Edit
//  @route  PUT /admin/edit-user
router.put("/edit-user", authenticatedGeneralManager, userController.editUser);


module.exports = router;
