const { Router } = require("express");

const homeController = require("../../controllers/home/homeController");

const router = new Router();


//  @desc GET HOME
//  @route  GET /socialmedias
router.get("/socialmedia", homeController.getSocialmedia);

//  @desc GET HOME
//  @route  GET /Separator
router.get("/separators", homeController.getSeparators);

//  @desc GET HOME
//  @route  GET /contacts
router.get("/contacts", homeController.getContacts);



//  @desc GET Menu Plans
//  @route  GET /user/menu-plans
router.get("/menu-plans", homeController.getMenuPlans);

//  @desc GET Workgroups
//  @route  GET /user/workgroups
router.get("/workgroups", homeController.getWorkgroups);

//  @desc GET Menu Categories
//  @route  GET /user/menu-categories
router.get("/menu-categories", homeController.getMenuCategories);


//  @desc GET Menus
//  @route  GET /menu/:address
router.get("/link/:address", homeController.getLink);


//  @desc GET Menus
//  @route  GET /menu/:address
router.get("/menu/:address", homeController.getMenu);


//  @desc GET Menus
//  @route  GET /menus
router.get("/menus", homeController.getMenus);


//  @desc GET Menus
//  @route  GET /menus
router.get("/cities", homeController.getCities);


module.exports = router;
