const { Router } = require("express");

const accountController = require("../../controllers/user/accountController");

const { authenticated } = require("../../middlewares/auth");

const router = new Router();

//  @desc   otp Handle
//  @route  POST /user/user-check
router.post("/user-check", accountController.handleUserCheck);


//  @desc   otp Handle
//  @route  POST /user/otp
router.post("/otp", accountController.handleOtp);



//  @desc   Login Handle
//  @route  POST /user/login
router.post("/login-otp", accountController.handleLoginOtp);

//  @desc   Login Handle
//  @route  POST /user/login
router.post("/login", accountController.handleLogin);



//  @desc   user Handle User password
//  @route  PUT /user/edit-password
router.put("/edit-password", authenticated, accountController.editPassword);

//  @desc   Handle reset Password
//  @route  POST /user/reset-password/:token
router.post("/reset-password", accountController.handleResetPassword);



//  @desc   User Handle Get Profile
//  @route  GET /user/profile
router.get("/profile", authenticated, accountController.profile);

//  @desc   User Handle Edit User
//  @route  PUT /user/edit-user
router.put("/edit-user", authenticated, accountController.editUser);

//  @desc   User Register Handle
//  @route  POST /user/completeUser
router.post("/completeUser", authenticated, accountController.completeUser);



module.exports = router;